           .cpu    "65c02"

            *           = $4000

            .text       "PGX"       ; Signature
            .byte       $03         ; machine type
            .word       keys.cmd    ; address
            .word       0           ; 3rd and 4th byte of starting addr (not used)

;            .text       $f2,$56     ; Auto-start signature
;            .byte       1           ; size, in # of blocks
;            .byte       2           ; mount to which block
;            .word       keys.cmd    ; address
;            .word       0
;            .word       0
;            .text       "'keys' program, extracted from DOS", $0;

            .dsection   code     

            .virtual    $0000   ; Zero page
mmu_ctrl    .byte       ?
io_ctrl     .byte       ?
reserved    .fill       6
mmu         .fill       8
indirecword .word       ?
            .dsection   dp
            .endv

event       .dstruct    kernel.event.event_t

keys        .namespace

.section  code
cmd         lda     #2
            sta     io_ctrl
            jsr     kernel.Display.Reset

            ldx     #<welcomemsg
            ldy     #>welcomemsg
            jsr     printmsg

            lda     #<event
            sta     kernel.args.events+0
            lda     #>event
            sta     kernel.args.events+1
        
_loop       jsr     kernel.Yield
            jsr     kernel.NextEvent
            bcs     _loop

            lda     event.type
            cmp     #kernel.event.key.PRESSED
            beq     _pressed
            cmp     #kernel.event.key.RELEASED
            beq     _released
            cmp     #kernel.event.JOYSTICK
            beq     _joy
            cmp     #kernel.event.mouse.CLICKS
            beq     _mouseclick
            cmp     #kernel.event.mouse.DELTA
            beq     _mousedelta
            bra     _loop

_mouseclick 
            ldx     #7
            lda     event.mouse.clicks.inner
            jsr     print_hex
            ldx     #10
            lda     event.mouse.clicks.middle
            jsr     print_hex
            ldx     #13
            lda     event.mouse.clicks.outer
            jsr     print_hex
            bra     _loop

_mousedelta 
            ldx     #7+160
            lda     event.mouse.delta.x
            jsr     print_hex
            ldx     #9+160
            lda     event.mouse.delta.y
            jsr     print_hex
            ldx     #11+160
            lda     event.mouse.delta.z
            jsr     print_hex
            ldx     #13+160
            lda     event.mouse.delta.buttons
            jsr     print_hex
            bra     _loop

_joy        ldx     #0
            lda     event.joystick.joy0
            jsr     print_hex
            lda     event.joystick.joy1
            jsr     print_hex
            bra     _loop

_released   lda     #' '
            bra     _show

_pressed    ldy     event.key.ascii
            cpy     #13
            beq     _done

            lda     #'X'
            bit     event.key.flags
            bmi     _show
            lda     event.key.ascii
_show       ldy     event.key.raw            
            sta     $c0f0,y
            jmp     _loop

_done       clc
            rts

print_hex   pha
            lsr     a
            lsr     a
            lsr     a
            lsr     a
            jsr     _digit
            pla
            and     #$0f
            jsr     _digit
            rts

_digit      phy
            tay
            lda     digits,y
            ply
            sta     $c131,x            
            inx
            rts

printmsg    stx     indirecword
            sty     indirecword+1
            ldy     #$00
printloop   lda     (indirecword),y
            beq     exitprint
            sta     $c000,y
            iny
            bra     printloop
exitprint   rts

digits      .text       "0123456789abcdef"
welcomemsg  .text       "This program shows the held status of keys. Press <ENTER> to quit.              "
            .text       "                                                                                "
            .text       $a0," meta: ",$a1,"  ",$a0,$96," ascii & extended keys...           ",$a0," f1-f8/12 ",$a1,"  ",$a0," joys ",$a1
            .text       " ",$a0," mous ",$a1,$0

.send
.endn